10       REM  PROGRAM TO COMPUTE VCA RATE FACTORS FOR EXPONENTIAL ENVELOPES.
20       REM  COMPUTES FACTORS FOR GROWING OR DECAYING ENVELOPES.
30       REM  RESULTS SENT TO SCREEN AND EITHER: COM1 OR FILE (VCARATES).
40       REM  RESULTS ARE GIVEN DIRECTLY IN 68000 SOURCE FORMAT.
50       REM  COMPUTES SCALING FACTORS FOR EACH OF RATE SETTINGS 1-98.
60       REM  SETTINGS 0 AND 99 ARE SPECIAL CASES DONE W/O COMPUTATION.
70       REM  ASSUMES ENVELOPE ENDPOINTS ARE 0FFFH AND 0001H (EITHER WAY).
80       REM  IN USE, VCA LEVEL IS SCALED BY RATE FACTOR AT EACH UPDATE TIME.
90      PRINT "Transmit results over COM1?" 
100      INPUT " ( 0 = no, 1 = yes) ... : ",TRANS% 
110      IF TRANS% THEN OPEN "COM1:9600,N,8" AS #1 ELSE OPEN "O",#1,"VCARATES"
120      IF TRANS%=0 THEN PRINT "Results will be saved in file VCARATES -"
130      INPUT "Enter the time for maximum attack/decay (seconds): ",MAXTIME#
140      MAXUPDATES# = MAXTIME#/8.000001E-03 
150      K# = (LOG(MAXUPDATES#)-LOG(2))/97
160      Z# = LOG(4096)
170      PRINT "Specify type of envelope curve -"
180      PRINT " 0 = decaying (negative) exponential"
190     PRINT " 1 = growing (positive) exponential" 
200     INPUT " -------->  : ",CURVETYPE
210     IF CURVETYPE<>1 THEN CURVETYPE = -1 
220     Z# = CURVETYPE*Z# 
230     PRINT "             DC.L    0000000000      ;  0    INF.   (NULL)    1.0000000000"
240     PRINT #1,"             DC.L    0000000000      ;  0    INF.   (NULL)    1.0000000000"
250     FOR RATESETTING% = 1 TO 98
260     NUMOFUPDATES# = 2*EXP(K#*(98-RATESETTING%))
270     FULLTIME# = NUMOFUPDATES#*8.000001E-03
280     UPDATEFACTOR# = EXP(Z#/NUMOFUPDATES#)
290     IF CURVETYPE=1 THEN GOTO 320
300     SCALEDFACTOR# = INT(UPDATEFACTOR#*65536#*65536#)  
310     GOTO 330
320     SCALEDFACTOR# = INT((UPDATEFACTOR#*65536#)+.5) 
330     PRINT "             DC.L    ";
340     PRINT USING "##########      ";SCALEDFACTOR#;
350     PRINT "; ";
360     PRINT USING "##   ";RATESETTING%; 
370     PRINT USING "##.##   ";FULLTIME#;
380     PRINT USING "####.#   ";NUMOFUPDATES#; 
390     PRINT USING "##.##########";UPDATEFACTOR#
400     PRINT #1,"               DC.L    ";
410     PRINT #1,USING "##########      ";SCALEDFACTOR#;
420     PRINT #1,"; ";
430     PRINT #1,USING "##   ";RATESETTING%; 
440     PRINT #1,USING "##.##   ";FULLTIME#;
450     PRINT #1,USING "####.#   ";NUMOFUPDATES#; 
460     PRINT #1,USING "##.##########";UPDATEFACTOR#
470     NEXT RATESETTING% 
480     CLOSE #1
###.#   ";NUMOFUPDATES#; 
4