10       REM  PROGRAM TO COMPUTE VCF RATE CONSTANTS FOR ENVELOPES.
20       REM  RESULTS SENT TO SCREEN AND EITHER: COM1 OR FILE (VCFRATES).
30       REM  RESULTS ARE GIVEN DIRECTLY IN 68000 SOURCE FORMAT.
40       REM  COMPUTES DELTA CONSTANTS FOR EACH OF RATE SETTINGS 1-98.
50       REM  SETTINGS 0 AND 99 ARE SPECIAL CASES DONE W/O COMPUTATION.
60       REM  ASSUMES ENVELOPE ENDPOINTS ARE 0FFFH AND 0001H (EITHER WAY).
70       REM  IN USE, RATE CONSTANT ADDED TO VCF ENVELOPE AT EACH UPDATE TIME.
80      REM  ONLY 12 M.S.BITS OF VCF CONTROL OUTPUT WORD ARE SIGNIFICANT -
90      REM  HOWEVER, CONTROL VALUE AND DELTA CONSTANTS ARE MAINTAINED AT
100      REM  16-BITS TO PROVIDE SUFFICIENT RATE RESOLUTION.
110       PRINT "Transmit results over COM1?" 
120      INPUT " ( 0 = no, 1 = yes) ... : ",TRANS% 
130      IF TRANS% THEN OPEN "COM1:9600,N,8" AS #1 ELSE OPEN "O",#1,"VCFRATES"
140      IF TRANS%=0 THEN PRINT "Results will be saved in file VCFRATES -"
150      INPUT "Enter the time for maximum attack/decay (seconds): ",MAXTIME#
160      MAXUPDATES# = MAXTIME#/8.000001E-03 
170      K# = (LOG(MAXUPDATES#)-LOG(2))/97
180     PRINT "             DC.W        0           ;  0    INF.    INF.    0"
190     PRINT #1,"             DC.W        0           ;  0    INF.    INF.    0"
200     FOR RATESETTING% = 1 TO 98
210     NUMOFUPDATES# = 2*EXP(K#*(98-RATESETTING%))
220     FULLTIME# = NUMOFUPDATES#*8.000001E-03
230     UPDATEDELTA# = 65536!/NUMOFUPDATES#
240     SCALEDFACTOR# = INT(UPDATEDELTA#) 
250     PRINT "             DC.W    ";
260     PRINT USING "#####           ";SCALEDFACTOR#;
270     PRINT "; ";
280     PRINT USING "##   ";RATESETTING%; 
290     PRINT USING "##.##   ";FULLTIME#;
300     PRINT USING "####.#   ";NUMOFUPDATES#; 
310     PRINT HEX$(SCALEDFACTOR#/16)
320     PRINT #1,"               DC.W    ";
330     PRINT #1,USING "#####           ";SCALEDFACTOR#;
340     PRINT #1,"; ";
350     PRINT #1,USING "##   ";RATESETTING%; 
360     PRINT #1,USING "##.##   ";FULLTIME#;
370     PRINT #1,USING "####.#   ";NUMOFUPDATES#; 
380     PRINT #1,HEX$(SCALEDFACTOR#/16)
390     NEXT RATESETTING% 
400     PRINT "             DC.W    65535           ; 99    0.00      1.0   FFF"
410     PRINT #1,"             DC.W    65535           ; 99    0.00      1.0   FFF"
420     CLOSE #1
  0.00      1.0   FFF"
410     PRINT #1,"             DC.W    65535        